<?php
/**
 * The template to display the widgets area in the header
 *
 * @package PRINTY
 * @since PRINTY 1.0
 */

// Header sidebar
$printy_header_name    = printy_get_theme_option( 'header_widgets' );
$printy_header_present = ! printy_is_off( $printy_header_name ) && is_active_sidebar( $printy_header_name );
if ( $printy_header_present ) {
	printy_storage_set( 'current_sidebar', 'header' );
	$printy_header_wide = printy_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $printy_header_name ) ) {
		dynamic_sidebar( $printy_header_name );
	}
	$printy_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $printy_widgets_output ) ) {
		$printy_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $printy_widgets_output );
		$printy_need_columns   = strpos( $printy_widgets_output, 'columns_wrap' ) === false;
		if ( $printy_need_columns ) {
			$printy_columns = max( 0, (int) printy_get_theme_option( 'header_columns' ) );
			if ( 0 == $printy_columns ) {
				$printy_columns = min( 6, max( 1, printy_tags_count( $printy_widgets_output, 'aside' ) ) );
			}
			if ( $printy_columns > 1 ) {
				$printy_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $printy_columns ) . ' widget', $printy_widgets_output );
			} else {
				$printy_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $printy_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'printy_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $printy_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $printy_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'printy_action_before_sidebar', 'header' );
				printy_show_layout( $printy_widgets_output );
				do_action( 'printy_action_after_sidebar', 'header' );
				if ( $printy_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $printy_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'printy_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
