<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package PRINTY
 * @since PRINTY 1.0
 */

// Page (category, tag, archive, author) title

if ( printy_need_page_title() ) {
	printy_sc_layouts_showed( 'title', true );
	printy_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								printy_show_post_meta(
									apply_filters(
										'printy_filter_post_meta_args', array(
											'components' => join( ',', printy_array_get_keys_by_value( printy_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', printy_array_get_keys_by_value( printy_get_theme_option( 'counters' ) ) ),
											'seo'        => printy_is_on( printy_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$printy_blog_title           = printy_get_blog_title();
							$printy_blog_title_text      = '';
							$printy_blog_title_class     = '';
							$printy_blog_title_link      = '';
							$printy_blog_title_link_text = '';
							if ( is_array( $printy_blog_title ) ) {
								$printy_blog_title_text      = $printy_blog_title['text'];
								$printy_blog_title_class     = ! empty( $printy_blog_title['class'] ) ? ' ' . $printy_blog_title['class'] : '';
								$printy_blog_title_link      = ! empty( $printy_blog_title['link'] ) ? $printy_blog_title['link'] : '';
								$printy_blog_title_link_text = ! empty( $printy_blog_title['link_text'] ) ? $printy_blog_title['link_text'] : '';
							} else {
								$printy_blog_title_text = $printy_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $printy_blog_title_class ); ?>">
								<?php
								$printy_top_icon = printy_get_term_image_small();
								if ( ! empty( $printy_top_icon ) ) {
									$printy_attr = printy_getimagesize( $printy_top_icon );
									?>
									<img src="<?php echo esc_url( $printy_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'printy' ); ?>"
										<?php
										if ( ! empty( $printy_attr[3] ) ) {
											printy_show_layout( $printy_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $printy_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $printy_blog_title_link ) && ! empty( $printy_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $printy_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $printy_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'printy_action_breadcrumbs' );
						$printy_breadcrumbs = ob_get_contents();
						ob_end_clean();
						printy_show_layout( $printy_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
