<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package PRINTY
 * @since PRINTY 1.0
 */

$printy_args = get_query_var( 'printy_logo_args' );

// Site logo
$printy_logo_type   = isset( $printy_args['type'] ) ? $printy_args['type'] : '';
$printy_logo_image  = printy_get_logo_image( $printy_logo_type );
$printy_logo_text   = printy_is_on( printy_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$printy_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $printy_logo_image['logo'] ) || ! empty( $printy_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $printy_logo_image['logo'] ) ) {
			if ( empty( $printy_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($printy_logo_image['logo']) && (int) $printy_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$printy_attr = printy_getimagesize( $printy_logo_image['logo'] );
				echo '<img src="' . esc_url( $printy_logo_image['logo'] ) . '"'
						. ( ! empty( $printy_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $printy_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $printy_logo_text ) . '"'
						. ( ! empty( $printy_attr[3] ) ? ' ' . wp_kses_data( $printy_attr[3] ) : '' )
						. '>';
			}
		} else {
			printy_show_layout( printy_prepare_macros( $printy_logo_text ), '<span class="logo_text">', '</span>' );
			printy_show_layout( printy_prepare_macros( $printy_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
