<?php
/**
 * The template to display default site header
 *
 * @package PRINTY
 * @since PRINTY 1.0
 */

$printy_header_css   = '';
$printy_header_image = get_header_image();
$printy_header_video = printy_get_header_video();
if ( ! empty( $printy_header_image ) && printy_trx_addons_featured_image_override( is_singular() || printy_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$printy_header_image = printy_get_current_mode_image( $printy_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $printy_header_image ) || ! empty( $printy_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $printy_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $printy_header_image ) {
		echo ' ' . esc_attr( printy_add_inline_css_class( 'background-image: url(' . esc_url( $printy_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( printy_is_on( printy_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight printy-full-height';
	}
	$printy_header_scheme = printy_get_theme_option( 'header_scheme' );
	if ( ! empty( $printy_header_scheme ) && ! printy_is_inherit( $printy_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $printy_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $printy_header_video ) ) {
		get_template_part( apply_filters( 'printy_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'printy_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( printy_is_on( printy_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'printy_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'printy_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'printy_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
