<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package PRINTY
 * @since PRINTY 1.0.06
 */

$printy_header_css   = '';
$printy_header_image = get_header_image();
$printy_header_video = printy_get_header_video();
if ( ! empty( $printy_header_image ) && printy_trx_addons_featured_image_override( is_singular() || printy_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$printy_header_image = printy_get_current_mode_image( $printy_header_image );
}

$printy_header_id = printy_get_custom_header_id();
$printy_header_meta = get_post_meta( $printy_header_id, 'trx_addons_options', true );
if ( ! empty( $printy_header_meta['margin'] ) ) {
	printy_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( printy_prepare_css_value( $printy_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $printy_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $printy_header_id ) ) ); ?>
				<?php
				echo ! empty( $printy_header_image ) || ! empty( $printy_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $printy_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $printy_header_image ) {
					echo ' ' . esc_attr( printy_add_inline_css_class( 'background-image: url(' . esc_url( $printy_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( printy_is_on( printy_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight printy-full-height';
				}
				$printy_header_scheme = printy_get_theme_option( 'header_scheme' );
				if ( ! empty( $printy_header_scheme ) && ! printy_is_inherit( $printy_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $printy_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $printy_header_video ) ) {
		get_template_part( apply_filters( 'printy_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'printy_action_show_layout', $printy_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'printy_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
