<?php
/**
 * The template to display the site logo in the footer
 *
 * @package PRINTY
 * @since PRINTY 1.0.10
 */

// Logo
if ( printy_is_on( printy_get_theme_option( 'logo_in_footer' ) ) ) {
	$printy_logo_image = printy_get_logo_image( 'footer' );
	$printy_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $printy_logo_image['logo'] ) || ! empty( $printy_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $printy_logo_image['logo'] ) ) {
					$printy_attr = printy_getimagesize( $printy_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $printy_logo_image['logo'] ) . '"'
								. ( ! empty( $printy_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $printy_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'printy' ) . '"'
								. ( ! empty( $printy_attr[3] ) ? ' ' . wp_kses_data( $printy_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $printy_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $printy_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
