<?php
/**
 * The template to display default site footer
 *
 * @package PRINTY
 * @since PRINTY 1.0.10
 */

$printy_footer_id = printy_get_custom_footer_id();
$printy_footer_meta = get_post_meta( $printy_footer_id, 'trx_addons_options', true );
if ( ! empty( $printy_footer_meta['margin'] ) ) {
	printy_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( printy_prepare_css_value( $printy_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $printy_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $printy_footer_id ) ) ); ?>
						<?php
						$printy_footer_scheme = printy_get_theme_option( 'footer_scheme' );
						if ( ! empty( $printy_footer_scheme ) && ! printy_is_inherit( $printy_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $printy_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'printy_action_show_layout', $printy_footer_id );
	?>
</footer><!-- /.footer_wrap -->
