<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PRINTY
 * @since PRINTY 1.0
 */

$printy_template_args = get_query_var( 'printy_template_args' );
if ( is_array( $printy_template_args ) ) {
	$printy_columns    = empty( $printy_template_args['columns'] ) ? 2 : max( 1, $printy_template_args['columns'] );
	$printy_blog_style = array( $printy_template_args['type'], $printy_columns );
    $printy_columns_class = printy_get_column_class( 1, $printy_columns, ! empty( $printy_template_args['columns_tablet']) ? $printy_template_args['columns_tablet'] : '', ! empty($printy_template_args['columns_mobile']) ? $printy_template_args['columns_mobile'] : '' );
} else {
	$printy_template_args = array();
	$printy_blog_style = explode( '_', printy_get_theme_option( 'blog_style' ) );
	$printy_columns    = empty( $printy_blog_style[1] ) ? 2 : max( 1, $printy_blog_style[1] );
    $printy_columns_class = printy_get_column_class( 1, $printy_columns );
}

$printy_post_format = get_post_format();
$printy_post_format = empty( $printy_post_format ) ? 'standard' : str_replace( 'post-format-', '', $printy_post_format );

?><div class="
<?php
if ( ! empty( $printy_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( printy_is_blog_style_use_masonry( $printy_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $printy_columns ) : esc_attr( $printy_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $printy_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $printy_columns )
		. ( 'portfolio' != $printy_blog_style[0] ? ' ' . esc_attr( $printy_blog_style[0] )  . '_' . esc_attr( $printy_columns ) : '' )
	);
	printy_add_blog_animation( $printy_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$printy_hover   = ! empty( $printy_template_args['hover'] ) && ! printy_is_inherit( $printy_template_args['hover'] )
								? $printy_template_args['hover']
								: printy_get_theme_option( 'image_hover' );

	if ( 'dots' == $printy_hover ) {
		$printy_post_link = empty( $printy_template_args['no_links'] )
								? ( ! empty( $printy_template_args['link'] )
									? $printy_template_args['link']
									: get_permalink()
									)
								: '';
		$printy_target    = ! empty( $printy_post_link ) && false === strpos( $printy_post_link, home_url() )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$printy_components = ! empty( $printy_template_args['meta_parts'] )
							? ( is_array( $printy_template_args['meta_parts'] )
								? $printy_template_args['meta_parts']
								: explode( ',', $printy_template_args['meta_parts'] )
								)
							: printy_array_get_keys_by_value( printy_get_theme_option( 'meta_parts' ) );

	// Featured image
	printy_show_post_featured( apply_filters( 'printy_filter_args_featured',
        array(
			'hover'         => $printy_hover,
			'no_links'      => ! empty( $printy_template_args['no_links'] ),
			'thumb_size'    => ! empty( $printy_template_args['thumb_size'] )
								? $printy_template_args['thumb_size']
								: printy_get_thumb_size(
									printy_is_blog_style_use_masonry( $printy_blog_style[0] )
										? (	strpos( printy_get_theme_option( 'body_style' ), 'full' ) !== false || $printy_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( printy_get_theme_option( 'body_style' ), 'full' ) !== false || $printy_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => printy_is_blog_style_use_masonry( $printy_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $printy_components,
			'class'         => 'dots' == $printy_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $printy_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $printy_post_link )
												? '<a href="' . esc_url( $printy_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $printy_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $printy_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $printy_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!