<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PRINTY
 * @since PRINTY 1.0
 */

$printy_template_args = get_query_var( 'printy_template_args' );
$printy_columns = 1;
if ( is_array( $printy_template_args ) ) {
	$printy_columns    = empty( $printy_template_args['columns'] ) ? 1 : max( 1, $printy_template_args['columns'] );
	$printy_blog_style = array( $printy_template_args['type'], $printy_columns );
	if ( ! empty( $printy_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $printy_columns > 1 ) {
	    $printy_columns_class = printy_get_column_class( 1, $printy_columns, ! empty( $printy_template_args['columns_tablet']) ? $printy_template_args['columns_tablet'] : '', ! empty($printy_template_args['columns_mobile']) ? $printy_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $printy_columns_class ); ?>">
		<?php
	}
} else {
	$printy_template_args = array();
}
$printy_expanded    = ! printy_sidebar_present() && printy_get_theme_option( 'expand_content' ) == 'expand';
$printy_post_format = get_post_format();
$printy_post_format = empty( $printy_post_format ) ? 'standard' : str_replace( 'post-format-', '', $printy_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $printy_post_format ) );
	printy_add_blog_animation( $printy_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$printy_hover      = ! empty( $printy_template_args['hover'] ) && ! printy_is_inherit( $printy_template_args['hover'] )
							? $printy_template_args['hover']
							: printy_get_theme_option( 'image_hover' );
	$printy_components = ! empty( $printy_template_args['meta_parts'] )
							? ( is_array( $printy_template_args['meta_parts'] )
								? $printy_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $printy_template_args['meta_parts'] ) )
								)
							: printy_array_get_keys_by_value( printy_get_theme_option( 'meta_parts' ) );
	printy_show_post_featured( apply_filters( 'printy_filter_args_featured',
		array(
			'no_links'   => ! empty( $printy_template_args['no_links'] ),
			'hover'      => $printy_hover,
			'meta_parts' => $printy_components,
			'thumb_size' => ! empty( $printy_template_args['thumb_size'] )
							? $printy_template_args['thumb_size']
							: printy_get_thumb_size( strpos( printy_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $printy_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$printy_template_args
	) );

	// Title and post meta
	$printy_show_title = get_the_title() != '';
	$printy_show_meta  = count( $printy_components ) > 0 && ! in_array( $printy_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $printy_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'printy_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'printy_action_before_post_title' );
				if ( empty( $printy_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'printy_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'printy_filter_show_blog_excerpt', empty( $printy_template_args['hide_excerpt'] ) && printy_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'printy_filter_show_blog_meta', $printy_show_meta, $printy_components, 'excerpt' ) ) {
				if ( count( $printy_components ) > 0 ) {
					do_action( 'printy_action_before_post_meta' );
					printy_show_post_meta(
						apply_filters(
							'printy_filter_post_meta_args', array(
								'components' => join( ',', $printy_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'printy_action_after_post_meta' );
				}
			}

			if ( printy_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'printy_action_before_full_post_content' );
					the_content( '' );
					do_action( 'printy_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'printy' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'printy' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				printy_show_post_content( $printy_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'printy_filter_show_blog_readmore',  ! isset( $printy_template_args['more_button'] ) || ! empty( $printy_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $printy_template_args['no_links'] ) ) {
					do_action( 'printy_action_before_post_readmore' );
					if ( printy_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						printy_show_post_more_link( $printy_template_args, '<p>', '</p>' );
					} else {
						printy_show_post_comments_link( $printy_template_args, '<p>', '</p>' );
					}
					do_action( 'printy_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $printy_template_args ) ) {
	if ( ! empty( $printy_template_args['slider'] ) || $printy_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
