<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PRINTY
 * @since PRINTY 1.0.50
 */

$printy_template_args = get_query_var( 'printy_template_args' );
if ( is_array( $printy_template_args ) ) {
	$printy_columns    = empty( $printy_template_args['columns'] ) ? 2 : max( 1, $printy_template_args['columns'] );
	$printy_blog_style = array( $printy_template_args['type'], $printy_columns );
} else {
	$printy_template_args = array();
	$printy_blog_style = explode( '_', printy_get_theme_option( 'blog_style' ) );
	$printy_columns    = empty( $printy_blog_style[1] ) ? 2 : max( 1, $printy_blog_style[1] );
}
$printy_blog_id       = printy_get_custom_blog_id( join( '_', $printy_blog_style ) );
$printy_blog_style[0] = str_replace( 'blog-custom-', '', $printy_blog_style[0] );
$printy_expanded      = ! printy_sidebar_present() && printy_get_theme_option( 'expand_content' ) == 'expand';
$printy_components    = ! empty( $printy_template_args['meta_parts'] )
							? ( is_array( $printy_template_args['meta_parts'] )
								? join( ',', $printy_template_args['meta_parts'] )
								: $printy_template_args['meta_parts']
								)
							: printy_array_get_keys_by_value( printy_get_theme_option( 'meta_parts' ) );
$printy_post_format   = get_post_format();
$printy_post_format   = empty( $printy_post_format ) ? 'standard' : str_replace( 'post-format-', '', $printy_post_format );

$printy_blog_meta     = printy_get_custom_layout_meta( $printy_blog_id );
$printy_custom_style  = ! empty( $printy_blog_meta['scripts_required'] ) ? $printy_blog_meta['scripts_required'] : 'none';

if ( ! empty( $printy_template_args['slider'] ) || $printy_columns > 1 || ! printy_is_off( $printy_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $printy_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( printy_is_off( $printy_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $printy_custom_style ) ) . "-1_{$printy_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $printy_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $printy_columns )
					. ' post_layout_' . esc_attr( $printy_blog_style[0] )
					. ' post_layout_' . esc_attr( $printy_blog_style[0] ) . '_' . esc_attr( $printy_columns )
					. ( ! printy_is_off( $printy_custom_style )
						? ' post_layout_' . esc_attr( $printy_custom_style )
							. ' post_layout_' . esc_attr( $printy_custom_style ) . '_' . esc_attr( $printy_columns )
						: ''
						)
		);
	printy_add_blog_animation( $printy_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'printy_action_show_layout', $printy_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $printy_template_args['slider'] ) || $printy_columns > 1 || ! printy_is_off( $printy_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
