<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PRINTY
 * @since PRINTY 1.0
 */

$printy_template_args = get_query_var( 'printy_template_args' );

if ( is_array( $printy_template_args ) ) {
	$printy_columns    = empty( $printy_template_args['columns'] ) ? 2 : max( 1, $printy_template_args['columns'] );
	$printy_blog_style = array( $printy_template_args['type'], $printy_columns );
    $printy_columns_class = printy_get_column_class( 1, $printy_columns, ! empty( $printy_template_args['columns_tablet']) ? $printy_template_args['columns_tablet'] : '', ! empty($printy_template_args['columns_mobile']) ? $printy_template_args['columns_mobile'] : '' );
} else {
	$printy_template_args = array();
	$printy_blog_style = explode( '_', printy_get_theme_option( 'blog_style' ) );
	$printy_columns    = empty( $printy_blog_style[1] ) ? 2 : max( 1, $printy_blog_style[1] );
    $printy_columns_class = printy_get_column_class( 1, $printy_columns );
}
$printy_expanded   = ! printy_sidebar_present() && printy_get_theme_option( 'expand_content' ) == 'expand';

$printy_post_format = get_post_format();
$printy_post_format = empty( $printy_post_format ) ? 'standard' : str_replace( 'post-format-', '', $printy_post_format );

?><div class="<?php
	if ( ! empty( $printy_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( printy_is_blog_style_use_masonry( $printy_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $printy_columns ) : esc_attr( $printy_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $printy_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $printy_columns )
				. ' post_layout_' . esc_attr( $printy_blog_style[0] )
				. ' post_layout_' . esc_attr( $printy_blog_style[0] ) . '_' . esc_attr( $printy_columns )
	);
	printy_add_blog_animation( $printy_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$printy_hover      = ! empty( $printy_template_args['hover'] ) && ! printy_is_inherit( $printy_template_args['hover'] )
							? $printy_template_args['hover']
							: printy_get_theme_option( 'image_hover' );

	$printy_components = ! empty( $printy_template_args['meta_parts'] )
							? ( is_array( $printy_template_args['meta_parts'] )
								? $printy_template_args['meta_parts']
								: explode( ',', $printy_template_args['meta_parts'] )
								)
							: printy_array_get_keys_by_value( printy_get_theme_option( 'meta_parts' ) );

	printy_show_post_featured( apply_filters( 'printy_filter_args_featured',
		array(
			'thumb_size' => ! empty( $printy_template_args['thumb_size'] )
				? $printy_template_args['thumb_size']
				: printy_get_thumb_size(
					'classic' == $printy_blog_style[0]
						? ( strpos( printy_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $printy_columns > 2 ? 'big' : 'huge' )
								: ( $printy_columns > 2
									? ( $printy_expanded ? 'square' : 'square' )
									: ($printy_columns > 1 ? 'square' : ( $printy_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( printy_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $printy_columns > 2 ? 'masonry-big' : 'full' )
								: ($printy_columns === 1 ? ( $printy_expanded ? 'huge' : 'big' ) : ( $printy_columns <= 2 && $printy_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $printy_hover,
			'meta_parts' => $printy_components,
			'no_links'   => ! empty( $printy_template_args['no_links'] ),
        ),
        'content-classic',
        $printy_template_args
    ) );

	// Title and post meta
	$printy_show_title = get_the_title() != '';
	$printy_show_meta  = count( $printy_components ) > 0 && ! in_array( $printy_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $printy_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'printy_filter_show_blog_meta', $printy_show_meta, $printy_components, 'classic' ) ) {
				if ( count( $printy_components ) > 0 ) {
					do_action( 'printy_action_before_post_meta' );
					printy_show_post_meta(
						apply_filters(
							'printy_filter_post_meta_args', array(
							'components' => join( ',', $printy_components ),
							'seo'        => false,
							'echo'       => true,
						), $printy_blog_style[0], $printy_columns
						)
					);
					do_action( 'printy_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'printy_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'printy_action_before_post_title' );
				if ( empty( $printy_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'printy_action_after_post_title' );
			}

			if( !in_array( $printy_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'printy_filter_show_blog_readmore', ! $printy_show_title || ! empty( $printy_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $printy_template_args['no_links'] ) ) {
						do_action( 'printy_action_before_post_readmore' );
						printy_show_post_more_link( $printy_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'printy_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $printy_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('printy_filter_show_blog_excerpt', empty($printy_template_args['hide_excerpt']) && printy_get_theme_option('excerpt_length') > 0, 'classic')) {
			printy_show_post_content($printy_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $printy_template_args['more_button'] )) {
			if ( empty( $printy_template_args['no_links'] ) ) {
				do_action( 'printy_action_before_post_readmore' );
				printy_show_post_more_link( $printy_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'printy_action_after_post_readmore' );
			}
		}
		$printy_content = ob_get_contents();
		ob_end_clean();
		printy_show_layout($printy_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
