<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PRINTY
 * @since PRINTY 1.71.0
 */

$printy_template_args = get_query_var( 'printy_template_args' );
if ( ! is_array( $printy_template_args ) ) {
	$printy_template_args = array(
								'type'    => 'band',
								'columns' => 1
								);
}

$printy_columns       = 1;

$printy_expanded      = ! printy_sidebar_present() && printy_get_theme_option( 'expand_content' ) == 'expand';

$printy_post_format   = get_post_format();
$printy_post_format   = empty( $printy_post_format ) ? 'standard' : str_replace( 'post-format-', '', $printy_post_format );

if ( is_array( $printy_template_args ) ) {
	$printy_columns    = empty( $printy_template_args['columns'] ) ? 1 : max( 1, $printy_template_args['columns'] );
	$printy_blog_style = array( $printy_template_args['type'], $printy_columns );
	if ( ! empty( $printy_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $printy_columns > 1 ) {
	    $printy_columns_class = printy_get_column_class( 1, $printy_columns, ! empty( $printy_template_args['columns_tablet']) ? $printy_template_args['columns_tablet'] : '', ! empty($printy_template_args['columns_mobile']) ? $printy_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $printy_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $printy_post_format ) );
	printy_add_blog_animation( $printy_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$printy_hover      = ! empty( $printy_template_args['hover'] ) && ! printy_is_inherit( $printy_template_args['hover'] )
							? $printy_template_args['hover']
							: printy_get_theme_option( 'image_hover' );
	$printy_components = ! empty( $printy_template_args['meta_parts'] )
							? ( is_array( $printy_template_args['meta_parts'] )
								? $printy_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $printy_template_args['meta_parts'] ) )
								)
							: printy_array_get_keys_by_value( printy_get_theme_option( 'meta_parts' ) );
	printy_show_post_featured( apply_filters( 'printy_filter_args_featured',
		array(
			'no_links'   => ! empty( $printy_template_args['no_links'] ),
			'hover'      => $printy_hover,
			'meta_parts' => $printy_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $printy_template_args['thumb_size'] )
								? $printy_template_args['thumb_size']
								: printy_get_thumb_size( 
								in_array( $printy_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( printy_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $printy_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$printy_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$printy_show_title = get_the_title() != '';
		$printy_show_meta  = count( $printy_components ) > 0 && ! in_array( $printy_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $printy_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'printy_filter_show_blog_categories', $printy_show_meta && in_array( 'categories', $printy_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'printy_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						printy_show_post_meta( apply_filters(
															'printy_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $printy_hover, 1
															)
											);
						?>
					</div>
					<?php
					$printy_components = printy_array_delete_by_value( $printy_components, 'categories' );
					do_action( 'printy_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'printy_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'printy_action_before_post_title' );
					if ( empty( $printy_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'printy_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $printy_template_args['excerpt_length'] ) && ! in_array( $printy_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$printy_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'printy_filter_show_blog_excerpt', empty( $printy_template_args['hide_excerpt'] ) && printy_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				printy_show_post_content( $printy_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'printy_filter_show_blog_meta', $printy_show_meta, $printy_components, 'band' ) ) {
			if ( count( $printy_components ) > 0 ) {
				do_action( 'printy_action_before_post_meta' );
				printy_show_post_meta(
					apply_filters(
						'printy_filter_post_meta_args', array(
							'components' => join( ',', $printy_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'printy_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'printy_filter_show_blog_readmore', ! $printy_show_title || ! empty( $printy_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $printy_template_args['no_links'] ) ) {
				do_action( 'printy_action_before_post_readmore' );
				printy_show_post_more_link( $printy_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'printy_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $printy_template_args ) ) {
	if ( ! empty( $printy_template_args['slider'] ) || $printy_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
