<?php
/**
 * The template to display Admin notices
 *
 * @package PRINTY
 * @since PRINTY 1.0.1
 */

$printy_theme_slug = get_option( 'template' );
$printy_theme_obj  = wp_get_theme( $printy_theme_slug );

?>
<div class="printy_admin_notice printy_rate_notice notice notice-info is-dismissible" data-notice="rate">
	<?php
	// Theme image
	$printy_theme_img = printy_get_file_url( 'screenshot.jpg' );
	if ( '' != $printy_theme_img ) {
		?>
		<div class="printy_notice_image"><img src="<?php echo esc_url( $printy_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'printy' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="printy_notice_title"><a href="<?php echo esc_url( printy_storage_get( 'theme_rate_url' ) ); ?>" target="_blank">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Rate our theme "%s", please', 'printy' ),
				$printy_theme_obj->get( 'Name' ) . ( PRINTY_THEME_FREE ? ' ' . __( 'Free', 'printy' ) : '' )
			)
		);
		?>
	</a></h3>
	<?php

	// Description
	?>
	<div class="printy_notice_text">
		<p><?php echo wp_kses_data( __( "We are glad you chose our WP theme for your website. You've done well customizing your website and we hope that you've enjoyed working with our theme.", 'printy' ) ); ?></p>
		<p><?php echo wp_kses_data( __( "It would be just awesome if you spend just a minute of your time to rate our theme or the customer service you've received from us.", 'printy' ) ); ?></p>
		<p class="printy_notice_text_info"><?php echo wp_kses_data( __( '* We love receiving your reviews! Every time you leave a review, our CEO Henry Rise gives $5 to homeless dog shelter! Save the planet with us!', 'printy' ) ); ?></p>
	</div>
	<?php

	// Buttons
	?>
	<div class="printy_notice_buttons">
		<?php
		// Link to the theme download page
		?>
		<a href="<?php echo esc_url( printy_storage_get( 'theme_rate_url' ) ); ?>" class="button button-primary" target="_blank"><i class="dashicons dashicons-star-filled"></i> 
			<?php
			// Translators: Add theme name
			echo esc_html( sprintf( __( 'Rate theme %s', 'printy' ), $printy_theme_obj->name ) );
			?>
		</a>
		<?php
		// Link to the theme support
		?>
		<a href="<?php echo esc_url( printy_storage_get( 'theme_support_url' ) ); ?>" class="button" target="_blank"><i class="dashicons dashicons-sos"></i> 
			<?php
			esc_html_e( 'Support', 'printy' );
			?>
		</a>
		<?php
		// Link to the theme documentation
		?>
		<a href="<?php echo esc_url( printy_storage_get( 'theme_doc_url' ) ); ?>" class="button" target="_blank"><i class="dashicons dashicons-book"></i> 
			<?php
			esc_html_e( 'Documentation', 'printy' );
			?>
		</a>
	</div>
</div>
