<?php
/**
 * The template to display Admin notices
 *
 * @package PRINTY
 * @since PRINTY 1.0.1
 */

$printy_theme_slug = get_option( 'template' );
$printy_theme_obj  = wp_get_theme( $printy_theme_slug );
?>
<div class="printy_admin_notice printy_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$printy_theme_img = printy_get_file_url( 'screenshot.jpg' );
	if ( '' != $printy_theme_img ) {
		?>
		<div class="printy_notice_image"><img src="<?php echo esc_url( $printy_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'printy' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="printy_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'printy' ),
				$printy_theme_obj->get( 'Name' ) . ( PRINTY_THEME_FREE ? ' ' . __( 'Free', 'printy' ) : '' ),
				$printy_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="printy_notice_text">
		<p class="printy_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $printy_theme_obj->description ) );
			?>
		</p>
		<p class="printy_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'printy' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="printy_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=printy_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'printy' );
			?>
		</a>
	</div>
</div>
