<?php
/**
 * Required plugins
 *
 * @package PRINTY
 * @since PRINTY 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
$printy_theme_required_plugins_groups = array(
	'core'          => esc_html__( 'Core', 'printy' ),
	'page_builders' => esc_html__( 'Page Builders', 'printy' ),
	'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'printy' ),
	'socials'       => esc_html__( 'Socials and Communities', 'printy' ),
	'events'        => esc_html__( 'Events and Appointments', 'printy' ),
	'content'       => esc_html__( 'Content', 'printy' ),
	'other'         => esc_html__( 'Other', 'printy' ),
);
$printy_theme_required_plugins        = array(
	'trx_addons'                 => array(
		'title'       => esc_html__( 'ThemeREX Addons', 'printy' ),
		'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'printy' ),
		'required'    => true,
		'logo'        => 'trx_addons.png',
		'group'       => $printy_theme_required_plugins_groups['core'],
	),
	'elementor'                  => array(
		'title'       => esc_html__( 'Elementor', 'printy' ),
		'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'printy' ),
		'required'    => false,
		'logo'        => 'elementor.png',
		'group'       => $printy_theme_required_plugins_groups['page_builders'],
	),
	'gutenberg'                  => array(
		'title'       => esc_html__( 'Gutenberg', 'printy' ),
		'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'printy' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'gutenberg.png',
		'group'       => $printy_theme_required_plugins_groups['page_builders'],
	),
	'js_composer'                => array(
		'title'       => esc_html__( 'WPBakery PageBuilder', 'printy' ),
		'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'printy' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'js_composer.jpg',
		'group'       => $printy_theme_required_plugins_groups['page_builders'],
	),
	'woocommerce'                => array(
		'title'       => esc_html__( 'WooCommerce', 'printy' ),
		'description' => esc_html__( "Connect the store to your website and start selling now", 'printy' ),
		'required'    => false,
                'install'     => false,
		'logo'        => 'woocommerce.png',
		'group'       => $printy_theme_required_plugins_groups['ecommerce'],
	),
	'elegro-payment'             => array(
		'title'       => esc_html__( 'Elegro Crypto Payment', 'printy' ),
		'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'printy' ),
		'required'    => false,
                'install'     => false,
		'logo'        => 'elegro-payment.png',
		'group'       => $printy_theme_required_plugins_groups['ecommerce'],
	),
	'instagram-feed'             => array(
		'title'       => esc_html__( 'Instagram Feed', 'printy' ),
		'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'printy' ),
		'required'    => false,
		'logo'        => 'instagram-feed.png',
		'group'       => $printy_theme_required_plugins_groups['socials'],
	),
	'mailchimp-for-wp'           => array(
		'title'       => esc_html__( 'MailChimp for WP', 'printy' ),
		'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'printy' ),
		'required'    => false,
		'logo'        => 'mailchimp-for-wp.png',
		'group'       => $printy_theme_required_plugins_groups['socials'],
	),
	'booked'                     => array(
		'title'       => esc_html__( 'Booked Appointments', 'printy' ),
		'description' => '',
		'required'    => false,
                'install'     => false,
		'logo'        => 'booked.png',
		'group'       => $printy_theme_required_plugins_groups['events'],
	),
	'quickcal'                     => array(
		'title'       => esc_html__( 'QuickCal', 'printy' ),
		'description' => '',
		'required'    => false,
                'install'     => false,
		'logo'        => 'quickcal.png',
		'group'       => $printy_theme_required_plugins_groups['events'],
	),
	'the-events-calendar'        => array(
		'title'       => esc_html__( 'The Events Calendar', 'printy' ),
		'description' => '',
		'required'    => false,
                'install'     => false,
		'logo'        => 'the-events-calendar.png',
		'group'       => $printy_theme_required_plugins_groups['events'],
	),
	'contact-form-7'             => array(
		'title'       => esc_html__( 'Contact Form 7', 'printy' ),
		'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'printy' ),
		'required'    => false,
		'logo'        => 'contact-form-7.png',
		'group'       => $printy_theme_required_plugins_groups['content'],
	),

	'latepoint'                  => array(
		'title'       => esc_html__( 'LatePoint', 'printy' ),
		'description' => '',
		'required'    => false,
                'install'     => false,
		'logo'        => printy_get_file_url( 'plugins/latepoint/latepoint.png' ),
		'group'       => $printy_theme_required_plugins_groups['events'],
	),
	'advanced-popups'                  => array(
		'title'       => esc_html__( 'Advanced Popups', 'printy' ),
		'description' => '',
		'required'    => false,
		'logo'        => printy_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
		'group'       => $printy_theme_required_plugins_groups['content'],
	),
	'devvn-image-hotspot'                  => array(
		'title'       => esc_html__( 'Image Hotspot by DevVN', 'printy' ),
		'description' => '',
		'required'    => false,
                'install'     => false,
		'logo'        => printy_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
		'group'       => $printy_theme_required_plugins_groups['content'],
	),
	'ti-woocommerce-wishlist'                  => array(
		'title'       => esc_html__( 'TI WooCommerce Wishlist', 'printy' ),
		'description' => '',
		'required'    => false,
                'install'     => false,
		'logo'        => printy_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
		'group'       => $printy_theme_required_plugins_groups['ecommerce'],
	),
	'woo-smart-quick-view'                  => array(
		'title'       => esc_html__( 'WPC Smart Quick View for WooCommerce', 'printy' ),
		'description' => '',
		'required'    => false,
                'install'     => false,
		'logo'        => printy_get_file_url( 'plugins/woo-smart-quick-view/woo-smart-quick-view.png' ),
		'group'       => $printy_theme_required_plugins_groups['ecommerce'],
	),
	'twenty20'                  => array(
		'title'       => esc_html__( 'Twenty20 Image Before-After', 'printy' ),
		'description' => '',
		'required'    => false,
        	'install'     => false,
		'logo'        => printy_get_file_url( 'plugins/twenty20/twenty20.png' ),
		'group'       => $printy_theme_required_plugins_groups['content'],
	),
	'essential-grid'             => array(
		'title'       => esc_html__( 'Essential Grid', 'printy' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'essential-grid.png',
		'group'       => $printy_theme_required_plugins_groups['content'],
	),
	'revslider'                  => array(
		'title'       => esc_html__( 'Revolution Slider', 'printy' ),
		'description' => '',
		'required'    => false,
        	'install'     => false,
		'logo'        => 'revslider.png',
		'group'       => $printy_theme_required_plugins_groups['content'],
	),
	'sitepress-multilingual-cms' => array(
		'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'printy' ),
		'description' => esc_html__( "Allows you to make your website multilingual", 'printy' ),
		'required'    => false,
		'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'sitepress-multilingual-cms.png',
		'group'       => $printy_theme_required_plugins_groups['content'],
	),
	'wp-gdpr-compliance'         => array(
		'title'       => esc_html__( 'Cookie Information', 'printy' ),
		'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'printy' ),
		'required'    => false,
		'logo'        => 'wp-gdpr-compliance.png',
		'group'       => $printy_theme_required_plugins_groups['other'],
	),
	'trx_updater'                => array(
		'title'       => esc_html__( 'ThemeREX Updater', 'printy' ),
		'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'printy' ),
		'required'    => false,
		'logo'        => 'trx_updater.png',
		'group'       => $printy_theme_required_plugins_groups['other'],
	),
);

if ( PRINTY_THEME_FREE ) {
	unset( $printy_theme_required_plugins['js_composer'] );
	unset( $printy_theme_required_plugins['booked'] );
	unset( $printy_theme_required_plugins['quickcal'] );
	unset( $printy_theme_required_plugins['the-events-calendar'] );
	unset( $printy_theme_required_plugins['calculated-fields-form'] );
	unset( $printy_theme_required_plugins['essential-grid'] );
	unset( $printy_theme_required_plugins['revslider'] );
	unset( $printy_theme_required_plugins['sitepress-multilingual-cms'] );
	unset( $printy_theme_required_plugins['trx_updater'] );
	unset( $printy_theme_required_plugins['trx_popup'] );
}

// Add plugins list to the global storage
printy_storage_set( 'required_plugins', $printy_theme_required_plugins );
