<?php

/* Drag and Drop Multiple File Upload for WooCommerce support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_theme_setup9', 9 );
    function printy_drag_and_drop_multiple_file_upload_for_woocommerce_theme_setup9() {
        add_action( 'wp_enqueue_scripts', 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_frontend_scripts', 1100 );
        add_action( 'wp_enqueue_scripts', 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_responsive_styles', 2000 );
        add_filter('printy_filter_merge_styles', 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_merge_styles');
        add_filter( 'printy_filter_merge_styles_responsive', 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_merge_styles_responsive' );
        if ( is_admin() ) {
            add_filter( 'printy_filter_tgmpa_required_plugins', 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_tgmpa_required_plugins' );
        }
    }
}
// Filter to add in the required plugins list
if ( ! function_exists( 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_tgmpa_required_plugins' ) ) {
    //Handler of the add_filter('printy_filter_tgmpa_required_plugins',	'printy_drag_and_drop_multiple_file_upload_for_woocommerce_tgmpa_required_plugins');
    function printy_drag_and_drop_multiple_file_upload_for_woocommerce_tgmpa_required_plugins( $list = array() ) {
        if ( printy_storage_isset( 'required_plugins', 'drag-and-drop-multiple-file-upload-for-woocommerce' ) && printy_storage_get_array( 'required_plugins', 'drag-and-drop-multiple-file-upload-for-woocommerce', 'install' ) !== false ) {
            $list[] = array(
                'name'     => printy_storage_get_array( 'required_plugins', 'drag-and-drop-multiple-file-upload-for-woocommerce', 'title' ),
                'slug'     => 'drag-and-drop-multiple-file-upload-for-woocommerce',
                'required' => false,
            );
        }
        return $list;
    }
}
// Check if plugin installed and activated
if ( ! function_exists( 'printy_exists_drag_and_drop_multiple_file_upload_for_woocommerce' ) ) {
    function printy_exists_drag_and_drop_multiple_file_upload_for_woocommerce() {
        return defined( 'DNDMFU_WC_VERSION' );
    }
}
// Enqueue styles for frontend
if ( ! function_exists( 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_frontend_scripts' ) ) {
    //Handler of the add_action( 'wp_enqueue_scripts', 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_frontend_scripts', 1100 );
    function printy_drag_and_drop_multiple_file_upload_for_woocommerce_frontend_scripts() {
        if ( printy_is_on( printy_get_theme_option( 'debug_mode' ) ) ) {
            $printy_url = printy_get_file_url( 'plugins/drag-and-drop-multiple-file-upload-for-woocommerce/drag-and-drop-multiple-file-upload-for-woocommerce.css' );
            if ( '' != $printy_url ) {
                wp_enqueue_style( 'printy-drag-and-drop-multiple-file-upload-for-woocommerce', $printy_url, array(), null );
            }
        }
    }
}
// Enqueue responsive styles for frontend
if ( ! function_exists( 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_responsive_styles' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_responsive_styles', 2000 );
	function printy_drag_and_drop_multiple_file_upload_for_woocommerce_responsive_styles() {
		if ( printy_is_on( printy_get_theme_option( 'debug_mode' ) ) ) {
			$printy_url = printy_get_file_url( 'plugins/drag-and-drop-multiple-file-upload-for-woocommerce/drag-and-drop-multiple-file-upload-for-woocommerce-responsive.css' );
			if ( '' != $printy_url ) {
				wp_enqueue_style( 'printy-drag-and-drop-multiple-file-upload-for-woocommerce-responsive', $printy_url, array(), null, printy_media_for_load_css_responsive( 'drag-and-drop-multiple-file-upload-for-woocommerce' ) );
			}
		}
	}
}
// Merge custom styles
if ( ! function_exists( 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_merge_styles' ) ) {
    //Handler of the add_filter('printy_filter_merge_styles', 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_merge_styles');
    function printy_drag_and_drop_multiple_file_upload_for_woocommerce_merge_styles( $list ) {
        $list[ 'plugins/drag-and-drop-multiple-file-upload-for-woocommerce/drag-and-drop-multiple-file-upload-for-woocommerce.css' ] = true;
        return $list;
    }
}
// Merge responsive styles
if ( ! function_exists( 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_merge_styles_responsive' ) ) {
	//Handler of the add_filter('printy_filter_merge_styles_responsive', 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_merge_styles_responsive');
	function printy_drag_and_drop_multiple_file_upload_for_woocommerce_merge_styles_responsive( $list ) {
		$list[ 'plugins/drag-and-drop-multiple-file-upload-for-woocommerce/drag-and-drop-multiple-file-upload-for-woocommerce-responsive.css' ] = true;
		return $list;
	}
}
// Add plugin-specific colors and fonts to the custom CSS
if ( printy_exists_drag_and_drop_multiple_file_upload_for_woocommerce() ) {
    require_once printy_get_file_dir( 'plugins/drag-and-drop-multiple-file-upload-for-woocommerce/drag-and-drop-multiple-file-upload-for-woocommerce-style.php' );
}
// Check plugin in the required plugins
if ( !function_exists( 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_importer_required_plugins' ) ) {
	add_filter( 'trx_addons_filter_importer_required_plugins',	'printy_drag_and_drop_multiple_file_upload_for_woocommerce_importer_required_plugins', 10, 2 );
	function printy_drag_and_drop_multiple_file_upload_for_woocommerce_importer_required_plugins($not_installed='', $list='') {
		if (strpos($list, 'drag-and-drop-multiple-file-upload-for-woocommerce')!==false && !printy_exists_drag_and_drop_multiple_file_upload_for_woocommerce() )
			$not_installed .= '<br>' . esc_html__('Drag and Drop Multiple File Upload for WooCommerce', 'printy');
		return $not_installed;
	}
}
// Set plugin's specific importer options
if ( !function_exists( 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options',	'printy_drag_and_drop_multiple_file_upload_for_woocommerce_importer_set_options' );
	function printy_drag_and_drop_multiple_file_upload_for_woocommerce_importer_set_options($options=array()) {
		if ( printy_exists_drag_and_drop_multiple_file_upload_for_woocommerce() && in_array('drag-and-drop-multiple-file-upload-for-woocommerce', $options['required_plugins']) ) {
			$options['additional_options'][]	= 'wcf_drag_n_drop_%';
		}
		return $options;
	}
}
// Prevent import plugin's specific options if plugin is not installed
if ( !function_exists( 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_importer_check_options' ) ) {
    add_filter( 'trx_addons_filter_import_theme_options', 'printy_drag_and_drop_multiple_file_upload_for_woocommerce_importer_check_options', 10, 4 );
    function printy_drag_and_drop_multiple_file_upload_for_woocommerce_importer_check_options($allow, $k, $v, $options) {
        if ($allow && (strpos($k, 'wcf_drag_n_drop_')===0) ) {
            $allow = printy_exists_drag_and_drop_multiple_file_upload_for_woocommerce() && in_array('drag-and-drop-multiple-file-upload-for-woocommerce', $options['required_plugins']);
        }
        return $allow;
    }
}