<?php
/**
 * The template to display single post
 *
 * @package PRINTY
 * @since PRINTY 1.0
 */

// Full post loading
$full_post_loading          = printy_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = printy_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = printy_get_theme_option( 'posts_navigation_scroll_which_block' );

// Position of the related posts
$printy_related_position   = printy_get_theme_option( 'related_position' );

// Type of the prev/next post navigation
$printy_posts_navigation   = printy_get_theme_option( 'posts_navigation' );
$printy_prev_post          = false;
$printy_prev_post_same_cat = printy_get_theme_option( 'posts_navigation_scroll_same_cat' );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( printy_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	printy_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'printy_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $printy_posts_navigation ) {
		$printy_prev_post = get_previous_post( $printy_prev_post_same_cat );  // Get post from same category
		if ( ! $printy_prev_post && $printy_prev_post_same_cat ) {
			$printy_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $printy_prev_post ) {
			$printy_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $printy_prev_post ) ) {
		printy_sc_layouts_showed( 'featured', false );
		printy_sc_layouts_showed( 'title', false );
		printy_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $printy_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'printy_filter_get_template_part', 'templates/content', 'single-' . printy_get_theme_option( 'single_style' ) ), 'single-' . printy_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $printy_related_position, 'inside' ) === 0 ) {
		$printy_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'printy_action_related_posts' );
		$printy_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $printy_related_content ) ) {
			$printy_related_position_inside = max( 0, min( 9, printy_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $printy_related_position_inside ) {
				$printy_related_position_inside = mt_rand( 1, 9 );
			}

			$printy_p_number         = 0;
			$printy_related_inserted = false;
			$printy_in_block         = false;
			$printy_content_start    = strpos( $printy_content, '<div class="post_content' );
			$printy_content_end      = strrpos( $printy_content, '</div>' );

			for ( $i = max( 0, $printy_content_start ); $i < min( strlen( $printy_content ) - 3, $printy_content_end ); $i++ ) {
				if ( $printy_content[ $i ] != '<' ) {
					continue;
				}
				if ( $printy_in_block ) {
					if ( strtolower( substr( $printy_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$printy_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $printy_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $printy_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$printy_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $printy_content[ $i + 1 ] && in_array( $printy_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$printy_p_number++;
					if ( $printy_related_position_inside == $printy_p_number ) {
						$printy_related_inserted = true;
						$printy_content = ( $i > 0 ? substr( $printy_content, 0, $i ) : '' )
											. $printy_related_content
											. substr( $printy_content, $i );
					}
				}
			}
			if ( ! $printy_related_inserted ) {
				if ( $printy_content_end > 0 ) {
					$printy_content = substr( $printy_content, 0, $printy_content_end ) . $printy_related_content . substr( $printy_content, $printy_content_end );
				} else {
					$printy_content .= $printy_related_content;
				}
			}
		}

		printy_show_layout( $printy_content );
	}

	// Comments
	do_action( 'printy_action_before_comments' );
	comments_template();
	do_action( 'printy_action_after_comments' );

	// Related posts
	if ( 'below_content' == $printy_related_position
		&& ( 'scroll' != $printy_posts_navigation || printy_get_theme_option( 'posts_navigation_scroll_hide_related' ) == 0 )
		&& ( ! $full_post_loading || printy_get_theme_option( 'open_full_post_hide_related' ) == 0 )
	) {
		do_action( 'printy_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $printy_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $printy_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $printy_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $printy_prev_post ) ); ?>"
			<?php do_action( 'printy_action_nav_links_single_scroll_data', $printy_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
