<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package PRINTY
 * @since PRINTY 1.0
 */

if ( printy_sidebar_present() ) {
	
	$printy_sidebar_type = printy_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $printy_sidebar_type && ! printy_is_layouts_available() ) {
		$printy_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $printy_sidebar_type ) {
		// Default sidebar with widgets
		$printy_sidebar_name = printy_get_theme_option( 'sidebar_widgets' );
		printy_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $printy_sidebar_name ) ) {
			dynamic_sidebar( $printy_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$printy_sidebar_id = printy_get_custom_sidebar_id();
		do_action( 'printy_action_show_layout', $printy_sidebar_id );
	}
	$printy_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $printy_out ) ) {
		$printy_sidebar_position    = printy_get_theme_option( 'sidebar_position' );
		$printy_sidebar_position_ss = printy_get_theme_option( 'sidebar_position_ss' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $printy_sidebar_position );
			echo ' sidebar_' . esc_attr( $printy_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $printy_sidebar_type );

			$printy_sidebar_scheme = apply_filters( 'printy_filter_sidebar_scheme', printy_get_theme_option( 'sidebar_scheme' ) );
			if ( ! empty( $printy_sidebar_scheme ) && ! printy_is_inherit( $printy_sidebar_scheme ) && 'custom' != $printy_sidebar_type ) {
				echo ' scheme_' . esc_attr( $printy_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="printy_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'printy_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $printy_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$printy_title = apply_filters( 'printy_filter_sidebar_control_title', 'float' == $printy_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'printy' ) : '' );
				$printy_text  = apply_filters( 'printy_filter_sidebar_control_text', 'above' == $printy_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'printy' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $printy_title ); ?>"><?php echo esc_html( $printy_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'printy_action_before_sidebar', 'sidebar' );
				printy_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $printy_out ) );
				do_action( 'printy_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'printy_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
