<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package PRINTY
 * @since PRINTY 1.0
 */

$printy_template = apply_filters( 'printy_filter_get_template_part', printy_blog_archive_get_template() );

if ( ! empty( $printy_template ) && 'index' != $printy_template ) {

	get_template_part( $printy_template );

} else {

	printy_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$printy_stickies   = is_home()
								|| ( in_array( printy_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) printy_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$printy_post_type  = printy_get_theme_option( 'post_type' );
		$printy_args       = array(
								'blog_style'     => printy_get_theme_option( 'blog_style' ),
								'post_type'      => $printy_post_type,
								'taxonomy'       => printy_get_post_type_taxonomy( $printy_post_type ),
								'parent_cat'     => printy_get_theme_option( 'parent_cat' ),
								'posts_per_page' => printy_get_theme_option( 'posts_per_page' ),
								'sticky'         => printy_get_theme_option( 'sticky_style' ) == 'columns'
															&& is_array( $printy_stickies )
															&& count( $printy_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		printy_blog_archive_start();

		do_action( 'printy_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'printy_action_before_page_author' );
			get_template_part( apply_filters( 'printy_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'printy_action_after_page_author' );
		}

		if ( printy_get_theme_option( 'show_filters' ) ) {
			do_action( 'printy_action_before_page_filters' );
			printy_show_filters( $printy_args );
			do_action( 'printy_action_after_page_filters' );
		} else {
			do_action( 'printy_action_before_page_posts' );
			printy_show_posts( array_merge( $printy_args, array( 'cat' => $printy_args['parent_cat'] ) ) );
			do_action( 'printy_action_after_page_posts' );
		}

		do_action( 'printy_action_blog_archive_end' );

		printy_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'printy_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'printy_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
