<?php
/**
 * The Header: Logo and main menu
 *
 * @package PRINTY
 * @since PRINTY 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( printy_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'printy_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'printy_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('printy_action_body_wrap_attributes'); ?>>

		<?php do_action( 'printy_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'printy_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('printy_action_page_wrap_attributes'); ?>>

			<?php do_action( 'printy_action_page_wrap_start' ); ?>

			<?php
			$printy_full_post_loading = ( printy_is_singular( 'post' ) || printy_is_singular( 'attachment' ) ) && printy_get_value_gp( 'action' ) == 'full_post_loading';
			$printy_prev_post_loading = ( printy_is_singular( 'post' ) || printy_is_singular( 'attachment' ) ) && printy_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $printy_full_post_loading && ! $printy_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="printy_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'printy_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'printy' ); ?></a>
				<?php if ( printy_sidebar_present() ) { ?>
				<a class="printy_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'printy_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'printy' ); ?></a>
				<?php } ?>
				<a class="printy_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'printy_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'printy' ); ?></a>

				<?php
				do_action( 'printy_action_before_header' );

				// Header
				$printy_header_type = printy_get_theme_option( 'header_type' );
				if ( 'custom' == $printy_header_type && ! printy_is_layouts_available() ) {
					$printy_header_type = 'default';
				}
				get_template_part( apply_filters( 'printy_filter_get_template_part', "templates/header-" . sanitize_file_name( $printy_header_type ) ) );

				// Side menu
				if ( in_array( printy_get_theme_option( 'menu_side' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'printy_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				get_template_part( apply_filters( 'printy_filter_get_template_part', 'templates/header-navi-mobile' ) );

				do_action( 'printy_action_after_header' );

			}
			?>

			<?php do_action( 'printy_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( printy_is_off( printy_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $printy_header_type ) ) {
						$printy_header_type = printy_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $printy_header_type && printy_is_layouts_available() ) {
						$printy_header_id = printy_get_custom_header_id();
						if ( $printy_header_id > 0 ) {
							$printy_header_meta = printy_get_custom_layout_meta( $printy_header_id );
							if ( ! empty( $printy_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$printy_footer_type = printy_get_theme_option( 'footer_type' );
					if ( 'custom' == $printy_footer_type && printy_is_layouts_available() ) {
						$printy_footer_id = printy_get_custom_footer_id();
						if ( $printy_footer_id ) {
							$printy_footer_meta = printy_get_custom_layout_meta( $printy_footer_id );
							if ( ! empty( $printy_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'printy_action_page_content_wrap_class', $printy_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'printy_filter_is_prev_post_loading', $printy_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( printy_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'printy_action_page_content_wrap_data', $printy_prev_post_loading );
			?>>
				<?php
				do_action( 'printy_action_page_content_wrap', $printy_full_post_loading || $printy_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'printy_filter_single_post_header', printy_is_singular( 'post' ) || printy_is_singular( 'attachment' ) ) ) {
					if ( $printy_prev_post_loading ) {
						if ( printy_get_theme_option( 'posts_navigation_scroll_which_block' ) != 'article' ) {
							do_action( 'printy_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$printy_path = apply_filters( 'printy_filter_get_template_part', 'templates/single-styles/' . printy_get_theme_option( 'single_style' ) );
					if ( printy_get_file_dir( $printy_path . '.php' ) != '' ) {
						get_template_part( $printy_path );
					}
				}

				// Widgets area above page
				$printy_body_style   = printy_get_theme_option( 'body_style' );
				$printy_widgets_name = printy_get_theme_option( 'widgets_above_page' );
				$printy_show_widgets = ! printy_is_off( $printy_widgets_name ) && is_active_sidebar( $printy_widgets_name );
				if ( $printy_show_widgets ) {
					if ( 'fullscreen' != $printy_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					printy_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $printy_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'printy_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $printy_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'printy_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'printy_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="printy_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( printy_is_singular( 'post' ) || printy_is_singular( 'attachment' ) )
							&& $printy_prev_post_loading 
							&& printy_get_theme_option( 'posts_navigation_scroll_which_block' ) == 'article'
						) {
							do_action( 'printy_action_between_posts' );
						}

						// Widgets area above content
						printy_create_widgets_area( 'widgets_above_content' );

						do_action( 'printy_action_page_content_start_text' );
