<?php
$printy_woocommerce_sc = printy_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $printy_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$printy_scheme = printy_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $printy_scheme ) && ! printy_is_inherit( $printy_scheme ) ) {
			echo ' scheme_' . esc_attr( $printy_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( printy_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( printy_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$printy_css      = '';
			$printy_bg_image = printy_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $printy_bg_image ) ) {
				$printy_css .= 'background-image: url(' . esc_url( printy_get_attachment_url( $printy_bg_image ) ) . ');';
			}
			if ( ! empty( $printy_css ) ) {
				echo ' style="' . esc_attr( $printy_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$printy_anchor_icon = printy_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$printy_anchor_text = printy_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $printy_anchor_icon ) || ! empty( $printy_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $printy_anchor_icon ) ? ' icon="' . esc_attr( $printy_anchor_icon ) . '"' : '' )
											. ( ! empty( $printy_anchor_text ) ? ' title="' . esc_attr( $printy_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( printy_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' printy-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$printy_css      = '';
				$printy_bg_mask  = printy_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$printy_bg_color_type = printy_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $printy_bg_color_type ) {
					$printy_bg_color = printy_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $printy_bg_color_type ) {
					$printy_bg_color = printy_get_scheme_color( 'bg_color', $printy_scheme );
				} else {
					$printy_bg_color = '';
				}
				if ( ! empty( $printy_bg_color ) && $printy_bg_mask > 0 ) {
					$printy_css .= 'background-color: ' . esc_attr(
						1 == $printy_bg_mask ? $printy_bg_color : printy_hex2rgba( $printy_bg_color, $printy_bg_mask )
					) . ';';
				}
				if ( ! empty( $printy_css ) ) {
					echo ' style="' . esc_attr( $printy_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$printy_caption     = printy_get_theme_option( 'front_page_woocommerce_caption' );
				$printy_description = printy_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $printy_caption ) || ! empty( $printy_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $printy_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $printy_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $printy_caption, 'printy_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $printy_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $printy_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $printy_description ), 'printy_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $printy_woocommerce_sc ) {
						$printy_woocommerce_sc_ids      = printy_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$printy_woocommerce_sc_per_page = count( explode( ',', $printy_woocommerce_sc_ids ) );
					} else {
						$printy_woocommerce_sc_per_page = max( 1, (int) printy_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$printy_woocommerce_sc_columns = max( 1, min( $printy_woocommerce_sc_per_page, (int) printy_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$printy_woocommerce_sc}"
										. ( 'products' == $printy_woocommerce_sc
												? ' ids="' . esc_attr( $printy_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $printy_woocommerce_sc
												? ' category="' . esc_attr( printy_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $printy_woocommerce_sc
												? ' orderby="' . esc_attr( printy_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( printy_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $printy_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $printy_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
