<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package PRINTY
 * @since PRINTY 1.0
 */

							do_action( 'printy_action_page_content_end_text' );
							
							// Widgets area below the content
							printy_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'printy_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'printy_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'printy_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'printy_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$printy_body_style = printy_get_theme_option( 'body_style' );
					$printy_widgets_name = printy_get_theme_option( 'widgets_below_page' );
					$printy_show_widgets = ! printy_is_off( $printy_widgets_name ) && is_active_sidebar( $printy_widgets_name );
					$printy_show_related = printy_is_single() && printy_get_theme_option( 'related_position' ) == 'below_page';
					if ( $printy_show_widgets || $printy_show_related ) {
						if ( 'fullscreen' != $printy_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $printy_show_related ) {
							do_action( 'printy_action_related_posts' );
						}

						// Widgets area below page content
						if ( $printy_show_widgets ) {
							printy_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $printy_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'printy_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'printy_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! printy_is_singular( 'post' ) && ! printy_is_singular( 'attachment' ) ) || ! in_array ( printy_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="printy_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'printy_action_before_footer' );

				// Footer
				$printy_footer_type = printy_get_theme_option( 'footer_type' );
				if ( 'custom' == $printy_footer_type && ! printy_is_layouts_available() ) {
					$printy_footer_type = 'default';
				}
				get_template_part( apply_filters( 'printy_filter_get_template_part', "templates/footer-" . sanitize_file_name( $printy_footer_type ) ) );

				do_action( 'printy_action_after_footer' );

			}
			?>

			<?php do_action( 'printy_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'printy_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'printy_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>